/*	delete.c	1.6	83/05/13	*/

#include <stdio.h>
#include "cpmio.h"
#include "cpmfio.h"

/*
 * Delete cp/m file
 */

/************************************************************************
 * NAME:	cpm_delete()
 *
 * DESCR:	Delete the named CPM file.
 *
 * ARGS:	
 *
 * RETURNS:	
 *
 * NOTES:	
 ************************************************************************/
int
cpm_delete(struct cpmfs *cpmfs, char *filename)
{
	char name[9], ext[4];
	C_FILE *cio;

	if (!(cpm_namesep(filename,name,ext)))
	    return(FALSE);

	if (cpm_searchdir(cpmfs, name, ext) < 0) {
	    return(FALSE);	    /* file not found */
	}

	cio = cpm_file_open(cpmfs, name, ext, READ);
	cio->c_dirp->status = (char) 0xe5;
	while(cio->c_dirp->blkcnt == (char) 0x80 && cpm_getnext(cio) != 0)
	    cio->c_dirp->status = (char) 0xe5;

	cpm_savedir(cpmfs);
	cpm_file_close(cio);

	/* 
	 * rebuild the bitmap completely instead of recovering
         * each block as they are deleted
	 */

	cpm_build_bmap(cpmfs); 

	return(TRUE);
}
